/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IConnectionManager;
import com.quantumdata.std.IQDPlugIn;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.StdConnectionManager;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class QDUtil {
    static /* synthetic */ Class class$0;

    public static ImageIcon createAppletImageIcon(String path) {
        int MAX_IMAGE_SIZE = 40000;
        int count = 0;
        for (int tries = 0; tries < 3; ++tries) {
            InputStream resStream = QDUtil.class.getResourceAsStream(path);
            if (resStream != null) {
                BufferedInputStream imgStream = new BufferedInputStream(resStream);
                byte[] buf = new byte[MAX_IMAGE_SIZE];
                try {
                    count = imgStream.read(buf);
                    imgStream.close();
                }
                catch (IOException ieo) {
                    System.out.println("Error: " + ieo.getMessage());
                }
                if (count <= 0) {
                    System.out.println("Couldn't find file: " + path);
                    continue;
                }
                return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf), "Image");
            }
            System.out.println("Couldn't find file: " + path);
            return null;
        }
        System.out.println("Couldn't load image: " + path);
        return null;
    }

    public static ImageIcon createAppletImageIcon(String path, Class srcClass) {
        int MAX_IMAGE_SIZE = 40000;
        int count = 0;
        for (int tries = 0; tries < 3; ++tries) {
            InputStream resStream = srcClass.getResourceAsStream(path);
            if (resStream != null) {
                BufferedInputStream imgStream = new BufferedInputStream(resStream);
                byte[] buf = new byte[MAX_IMAGE_SIZE];
                try {
                    count = imgStream.read(buf);
                    imgStream.close();
                }
                catch (IOException ieo) {
                    System.out.println("Error: " + ieo.getMessage());
                }
                if (count <= 0) {
                    System.out.println("Couldn't find file: " + path);
                    continue;
                }
                return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf), "Image");
            }
            System.out.println("Couldn't find file: " + path);
            return null;
        }
        System.out.println("Couldn't load image: " + path);
        return null;
    }

    public static boolean isDigits(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String fillHex(int value, int minLen) {
        StringBuffer buf = new StringBuffer();
        String txt = Integer.toHexString(value);
        int n = txt.length();
        int i = minLen - n;
        while (i > 0) {
            buf.append('0');
            --i;
        }
        if (n > minLen) {
            txt = txt.substring(n - minLen);
            n = minLen;
        }
        i = 0;
        while (i < n) {
            buf.append(txt.charAt(i));
            ++i;
        }
        return buf.toString();
    }

    public static JFrame runStandalonePlugIn(IQDPlugIn plugin) {
        JFrame frame = new JFrame();
        QDUtil.createPlugInFrame(frame, plugin.getTopPanel(new StdContext(frame), ""));
        frame.addWindowListener(new CloseHandler(plugin));
        plugin.starting();
        return frame;
    }

    public static JFrame runStandalonePlugIn(IQDPlugIn plugin, IQDPluginContext pc, String instrName) {
        JFrame frame = new JFrame();
        QDUtil.createPlugInFrame(frame, plugin.getTopPanel(pc, instrName));
        frame.addWindowListener(new CloseHandler(plugin));
        plugin.starting();
        return frame;
    }

    private static void createPlugInFrame(JFrame frame, JPanel mainPanel) {
        frame.getContentPane().add(mainPanel);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static String getInstrumentIP(Component parent) {
        String selectedValue = JOptionPane.showInputDialog(parent, "Enter an IP Address:", "Connect to?", 3);
        if (selectedValue == null || !(selectedValue instanceof String)) {
            return "";
        }
        String genIP = selectedValue;
        return genIP;
    }

    private static class CloseHandler
    extends WindowAdapter {
        private IQDPlugIn m_plugin;

        public CloseHandler(IQDPlugIn plugin) {
            this.m_plugin = plugin;
        }

        public void windowClosing(WindowEvent e) {
            this.m_plugin.closing();
        }
    }

    static class StdContext
    implements IQDPluginContext {
        private IConnectionManager m_conMangr = null;

        public StdContext(JFrame owner) {
            this.m_conMangr = new StdConnectionManager(owner);
        }

        public IConnectionManager getConnectionManager() {
            return this.m_conMangr;
        }
    }
}

